<?php
date_default_timezone_set("UTC");
include 'config/config.php';
function pr($s){
    echo "<pre>";
    print_r($s);
    echo "</pre>";
}
function secondsToTime($seconds) {
    $dtF = new \DateTime('@0');
    $dtT = new \DateTime("@$seconds");
    return $dtF->diff($dtT)->format('%h hr : %i min: %s sec');
}
function getMinutes($time){
    $timeArr = explode(":",$time);
    if(count($timeArr)>1){
        return $timeArr[0].":".$timeArr[1];
    }
}
function getDiffTime($endTime,$startTime){
    $timeArr = explode(":",$endTime);
    if(count($timeArr)>1){
       $end=  ($timeArr[0]*60) +$timeArr[1];
    }
    $stimeArr = explode(":",$startTime);
    if(count($stimeArr)>1){
        $start = ($stimeArr[0]*60) +$stimeArr[1];
    }
    $diff = $end-$start;
    return floor($diff/60).":".sprintf("%02d", $diff%60);
}
function getAddedTime($endTime,$startTime){
    $timeArr = explode(":",$endTime);
    if(count($timeArr)>1){
       $end=  ($timeArr[0]*60) +$timeArr[1];
    }
    $stimeArr = explode(":",$startTime);
    if(count($stimeArr)>1){
        $start = ($stimeArr[0]*60) +$stimeArr[1];
    }
    $diff = $end+$start;
    return floor($diff/60).":".sprintf("%02d", $diff%60);
}
function contains($find,$word){
    return strpos(strtoupper($word), strtoupper($find)) !== false;
}
function extractDate($datetime){
    $dArr = explode(" ",$datetime);
    if(count($dArr)>0){
        return $dArr[0];
    }
}
function extractTime($datetime){
    $dArr = explode(" ",$datetime);
    if(count($dArr)>0){
        return $dArr[1];
    }
}
if (mysqli_connect_errno()) {
  echo "Failed to connect to MySQL: " . mysqli_connect_error();
  exit();
}
function sortByOrder($a, $b) {
    return $a['order'] > $b['order'];
}

function getAssociateArr($input){
    if (array_key_exists("date",$input)){
        $sql = "SELECT * FROM scanner where AuthDateTime LIKE '".$input["date"]."%' ORDER BY PersonName,AuthDateTime ASC";
    }else if(array_key_exists("ID",$input)){
        $last_day = date('Y-m-d', strtotime(date("Y-m-d"). ' - 40 days'));
        $sql = "SELECT * FROM scanner where `AuthDateTime` >=  '".$last_day."' AND ID = '".$input["ID"]."' ORDER BY AuthDateTime";
    }else if(array_key_exists("PersonName",$input)){
        $last_day = date('Y-m-d', strtotime(date("Y-m-d"). ' - 40 days'));
        $sql = "SELECT * FROM scanner where `AuthDateTime` >=  '".$last_day."' AND PersonName LIKE '%".$input["PersonName"]."%' ORDER BY AuthDateTime";
    }else{
        return "";
    }
  //  echo "Query=".$sql;
    $result = mysqli_query($GLOBALS['con'],$sql);
 //   $cnt = 0;
    $html="";
    // Numeric array
    $resu =array();
    while($row =  mysqli_fetch_array($result, MYSQLI_ASSOC)){
        if($row["AuthDateTime"]!="0000-00-00 00:00:00" && extractTime($row["AuthDateTime"])!="00:00:00"){
            if(!array_key_exists($row["ID"],$rowName) && $row["PersonName"]!=""){
                $rowName[$row["ID"]] = $row["PersonName"];
               // echo "First=".$row["PersonName"]."<br>";
            }else{
                //echo "Next=".$row["PersonName"]."<br>";
            }
          //  $row["order"] = $rowName[$row["ID"]]."_".getMinutes($row["AuthDateTime"])."_".$row["DeviceName"];
            $k = $row["ID"]."_".getMinutes($row["AuthDateTime"])."_".$row["DeviceName"];
            $all_rows[$k] = $row;
        }
    }
     foreach($all_rows as $k=>$row){
    
        $all_rows[$k]["order"] = $rowName[$row["ID"]]."_".getMinutes($row["AuthDateTime"])."_".$row["DeviceName"];
    } 
  //  pr($all_rows);
    usort($all_rows,"sortByOrder");
//    pr($all_rows);
    foreach($all_rows as $row){
     $now = time();
     $time =  extractTime($row["AuthDateTime"]);
     $date_ =  extractDate($row["AuthDateTime"]);
     $id = $row["ID"]."_".$date_;
     if(in_array($id,array_keys($resu))){
        $timing = $resu[$id]["timings"];
        $prev_timing = $timing[$cnt[$id]];
        if(in_array("IN",array_keys($prev_timing)) && contains("OUT",$row["DeviceName"])){
            $prev_timing["OUT"] = getMinutes($time);
            $timing[$cnt[$id]] = $prev_timing;
        }else if(in_array("IN",array_keys($prev_timing)) && contains("IN",$row["DeviceName"])){
            $timing[++$cnt[$id]] = array("IN" =>getMinutes($time));
        }else if(in_array("OUT",array_keys($prev_timing)) && contains("OUT",$row["DeviceName"])){
            $timing[++$cnt[$id]] = array("OUT" =>getMinutes($time));
        }else if(in_array("OUT",array_keys($prev_timing)) && contains("IN",$row["DeviceName"])){
            $timing[++$cnt[$id]] = array("IN" =>getMinutes($time));
        }else{
            
        }
        $resu[$id]["timings"] = $timing;
     }else{
        $cnt[$id]=0;
        if(contains("IN",$row["DeviceName"])){
            $flag_ = "IN";    
        }else{
            $flag_ = "OUT";
        }
        $resu[$id] =  array("name"=>$rowName[$row["ID"]],"id"=>$row["ID"],"date"=>extractDate($row["AuthDateTime"]),"timings"=>array($cnt[$id] =>array($flag_ =>getMinutes($time))));
     }
    }
    //pr($resu);
    return $resu;
}
function getReportContent($input){
    $resu = getAssociateArr($input);
    //pr($resu);
    
    foreach($resu as $k => $val) {
        $startTime ="";
        $endTime ="";
    	if(is_array($val["timings"])){
    		$arrCnt = count($val["timings"]);
    		if($arrCnt>1){
    		    $cls = 'red';
    		    $tot_time ="0:00";
    		    foreach($val["timings"] as $each){
              	    $in = (array_key_exists("IN", $each))?getMinutes($each["IN"]):"";
              	    $out = (array_key_exists("OUT", $each))?getMinutes($each["OUT"]):"";
              	    $inside_diff = ($in!="" && $out !="")?getDiffTime($each["OUT"],$each["IN"]):"";
              	    if($inside_diff!=""){
              	        $tot_time = getAddedTime($tot_time,$inside_diff);
              	    }
              	}
    		}else{
    		    $cls ='';
    		}
    		if($arrCnt>0){
    			if(array_key_exists("IN", $val["timings"][0])){
    				$startTime = $val["timings"][0]["IN"];
    			}
    			
    			if(array_key_exists("OUT", $val["timings"][$arrCnt-1])){
    				$endTime = $val["timings"][$arrCnt-1]["OUT"];
    			}
    		}
    		if($cls ==''){
    		    if($endTime!="" && $startTime!=""){
    		        $tot_time = getDiffTime($endTime,$startTime);
    		    }else{
    		        $tot_time = "0:00";
    		    }
    		}
    	}
      	$html.="<tr class='new'><td>". $k."</td><td>".$val["name"]."</td><td>".$val["date"]."</td><td>".getMinutes($startTime)."</td><td>".getMinutes($endTime)."</td><td></td><td><span class='$cls'>".$tot_time."</span></td></tr>";
      	if(is_array($val["timings"])){
      	    $arrCnt = count($val["timings"]);
          	if($arrCnt>1){
          	   foreach($val["timings"] as $each){
          	    $in = (array_key_exists("IN", $each))?getMinutes($each["IN"]):"";
          	    $out = (array_key_exists("OUT", $each))?getMinutes($each["OUT"]):"";
          	    $inside_diff = ($in!="" && $out !="")?getDiffTime($each["OUT"],$each["IN"]):"";
          	    $html.="<tr><td></td><td></td><td></td><td>".$in."</td><td>".$out."</td><td>$inside_diff</td><td></td></tr>";
          	   }
          	    
          	}
      	}
    }
    return $html;
}
function getClearReportContent($input){
    $resu = getAssociateArr($input);
    $j=0;
    foreach($resu as $k => $val) {
        $startTime ="";
        $endTime ="";
        $startFlag = false;
    	if(is_array($val["timings"])){
    		$arrCnt = count($val["timings"]);
    		if($arrCnt>1){
    		    $cls = 'red';
    		    $tot_time ="0:00";
    		 //   pr($val["timings"]);
    		    foreach($val["timings"] as $each){
    		        if($startTime=="" && $each["IN"]!=""){
    		            $startTime = $each["IN"];
    		            $startFlag = true;
    		        }
    		        if($each["OUT"]!="" && $startFlag){
    		            $endTime = $each["OUT"];
    		        }
              	    $in = (array_key_exists("IN", $each))?getMinutes($each["IN"]):"";
              	    $out = (array_key_exists("OUT", $each))?getMinutes($each["OUT"]):"";
              	    $inside_diff = ($in!="" && $out !="")?getDiffTime($each["OUT"],$each["IN"]):"";
              	    if($inside_diff!=""){
              	        $tot_time = getAddedTime($tot_time,$inside_diff);
              	    }
              	}
    		}else{
    		    $cls ='';
    		}
    		if($arrCnt>0){
    			if(array_key_exists("IN", $val["timings"][0])){
    				$startTime = $val["timings"][0]["IN"];
    			}
    			
    			if(array_key_exists("OUT", $val["timings"][$arrCnt-1])){
    				$endTime = $val["timings"][$arrCnt-1]["OUT"];
    			}
    		}
    		if($cls ==''){
    		    if($endTime!="" && $startTime!=""){
    		        $tot_time = getDiffTime($endTime,$startTime);
    		    }else{
    		        $tot_time = "0:00";
    		    }
    		}
    	}
    	if($tot_time=="0:00"){
    	   $tot_time=""; 
    	}
    	$cls_bg = (($startTime=="" || $endTime =="") && $val["date"]!=date("Y-m-d"))?"inout_missing":"";
    	$nameOutArr = getProperName($val["name"]);
    	
      	
		$op_key = $nameOutArr["name"].$j;
		
		$j++;
		
		$output_array[$op_key] = array("id"=>$val["id"],"dept"=>$nameOutArr["dept"],"name"=>$nameOutArr["name"],"date"=>$val["date"],"startTime"=>getMinutes($startTime),"endTime"=>getMinutes($endTime),"tot_time"=>$tot_time,"row_cls"=>$cls_bg,"tot_time_cls"=>$cls,"type"=>"main");
		$k=0;
      	if(is_array($val["timings"])){
      	    $arrCnt = count($val["timings"]);
          	if($arrCnt>1){
          	   foreach($val["timings"] as $each){
          	    $in = (array_key_exists("IN", $each))?getMinutes($each["IN"]):"";
          	    $out = (array_key_exists("OUT", $each))?getMinutes($each["OUT"]):"";
          	    $inside_diff = ($in!="" && $out !="")?getDiffTime($each["OUT"],$each["IN"]):"";
          	    $cls_bg = (($in=="" || $out =="") && $val["date"]!=date("Y-m-d"))?"inout_missing":"";
          	    $op_key = $nameOutArr["name"].$j.$k;
				$output_array[$op_key] = array("startTime"=>$in,"endTime"=>$out,"part_duration"=>$inside_diff,"row_cls"=>$cls_bg,"type"=>"sub");
				$k++;
          	   }
          	    
          	}
      	}
    }
    return convertArrayFromHtml($output_array);
}
function convertArrayFromHtml($output_array){
	uksort($output_array,'strcasecmp');
	$html="";
	foreach($output_array as $each){
		if($each['type']=="main"){
				$html.="<tr class='new ".$each['row_cls']."'><td><span class='uni_id_cls'>".$each['id']."</span></td><td><span class='dept_cls'>".$each["dept"]."</span></td><td><span class='person_name_cls'>".$each["name"]."</span></td><td><span class='date_cls'>".$each["date"]."</span></td><td class='aleft'>".$each['startTime']."</td><td class='aleft'>".$each['endTime']."</td><td class='aleft'></td><td class='aleft'><span class='".$each['tot_time_cls']."' >".$each['tot_time']."</span></td></tr>";
		}else{
			$html.="<tr class='".$each['row_cls']."'><td></td><td></td><td></td><td></td><td class='aleft'>".$each['startTime']."</td><td class='aleft'>".$each['endTime']."</td><td class='aleft'>".$each['part_duration']."</td><td></td></tr>";	
		}
	}
	return $html;
		
				
}
function getVisitorsCount(){
    $yesterday = time()-(24*60*60);
    $sql = "SELECT DISTINCT s1.* FROM scanner s1 INNER JOIN ( SELECT max(AuthDateTime) as AuthMaxDate,SeqNum,ID FROM `scanner` GROUP BY ID ) s2 ON s2.AuthMaxDate = s1.AuthDateTime WHERE  UNIX_TIMESTAMP(s1.AuthDateTime) <= '".$yesterday."' AND s1.DeviceName LIKE '%IN%' order by s1.PersonName ASC, s1.AuthDateTime DESC";
  
    $result = mysqli_query($GLOBALS['con'],$sql);
    $cnt = mysqli_num_rows($result);
  if($_GET["debug"]==1){
      echo $sql."<br>";
      echo "Count:".$cnt.";";
  }
    return $cnt;
}
function getVisitorsCount_deprecated($now){
    $sql = "SELECT DISTINCT s1.* FROM scanner s1 INNER JOIN ( SELECT max(AuthDateTime) as AuthMaxDate,SeqNum,ID FROM `scanner` GROUP BY ID ) s2 ON s2.AuthMaxDate = s1.AuthDateTime order by s1.PersonName ASC, s1.Timestamp DESC";

    $result = mysqli_query($GLOBALS['con'],$sql);
    $cnt = 0;
    $html="";
    // Numeric array
    while($row =  mysqli_fetch_array($result, MYSQLI_ASSOC)){
     
        //$row["diff_time"] = secondsToTime($row["diff"]);
        if(strpos($row["DeviceName"], 'IN') !== false && $now<=strtotime($row["AuthDateTime"])+(24*60*60)){
            $cnt++;
        }
           
    }
    return $cnt;
}
function getProperName($txt){
    $txt = trim($txt);
    $start = strpos($txt,"(");
    $end =strpos($txt,")");
   $dept =  substr($txt,$start,$end-$start+1);
    if($end!=""){
    	$arr = array("dept"=>trim(substr(trim($dept),1,strlen($dept)-2)),"name"=>trim(str_replace($dept,"",$txt)));
    }else{
        $arr =array("dept"=>"","name"=>$txt);
    }
    return $arr;
}
?>