<?php
date_default_timezone_set("UTC");
include 'config/config.php';
function pr($s){
    echo "<pre>";
    print_r($s);
    echo "</pre>";
}
function secondsToTime($seconds) {
    $dtF = new \DateTime('@0');
    $dtT = new \DateTime("@$seconds");
    return $dtF->diff($dtT)->format('%h hr : %i min: %s sec');
}
function getMinutes($time){
    $timeArr = explode(":",$time);
    if(count($timeArr)>1){
        return $timeArr[0].":".$timeArr[1];
    }
}
function getDiffTime($endTime,$startTime){
    $timeArr = explode(":",$endTime);
    if(count($timeArr)>1){
       $end=  ($timeArr[0]*60) +$timeArr[1];
    }
    $stimeArr = explode(":",$startTime);
    if(count($stimeArr)>1){
        $start = ($stimeArr[0]*60) +$stimeArr[1];
    }
    $diff = $end-$start;
    return floor($diff/60).":".sprintf("%02d", $diff%60);
}
function getAddedTime($endTime,$startTime){
    $timeArr = explode(":",$endTime);
    if(count($timeArr)>1){
       $end=  ($timeArr[0]*60) +$timeArr[1];
    }
    $stimeArr = explode(":",$startTime);
    if(count($stimeArr)>1){
        $start = ($stimeArr[0]*60) +$stimeArr[1];
    }
    $diff = $end+$start;
    return floor($diff/60).":".sprintf("%02d", $diff%60);
}
function contains($find,$word){
    return strpos(strtoupper($word), strtoupper($find)) !== false;
}
function extractDate($datetime){
    $dArr = explode(" ",$datetime);
    if(count($dArr)>0){
        return $dArr[0];
    }
}
function extractTime($datetime){
    $dArr = explode(" ",$datetime);
    if(count($dArr)>0){
        return $dArr[1];
    }
}
if (mysqli_connect_errno()) {
  echo "Failed to connect to MySQL: " . mysqli_connect_error();
  exit();
}
function sortByOrder($a, $b) {
    return $a['order'] > $b['order'];
}

function getAssociateArr($input){
    if (array_key_exists("date",$input)){
        $sql = "SELECT * FROM scanner where AuthDateTime LIKE '".$input["date"]."%' ORDER BY PersonName,AuthDateTime ASC";
     //echo $sql;
    }else if(array_key_exists("ID",$input)){
        $last_day = date('Y-m-d', strtotime(date("Y-m-d"). ' - 40 days'));
        $sql = "SELECT * FROM scanner where `AuthDateTime` >=  '".$last_day."' AND ID = '".$input["ID"]."' ORDER BY AuthDateTime";
    }else if(array_key_exists("PersonName",$input)){
        $last_day = date('Y-m-d', strtotime(date("Y-m-d"). ' - 40 days'));
        $sql = "SELECT * FROM scanner where `AuthDateTime` >=  '".$last_day."' AND PersonName LIKE '%".$input["PersonName"]."%' ORDER BY AuthDateTime";
    }else{
        return "";
    }
  //  echo "Query=".$sql;
    $result = mysqli_query($GLOBALS['con'],$sql);
   // $cnt = 0;
    $html="";
    // Numeric array
    $resu =array();
    while($row =  mysqli_fetch_array($result, MYSQLI_ASSOC)){
        if($row["AuthDateTime"]!="0000-00-00 00:00:00" && extractTime($row["AuthDateTime"])!="00:00:00"){
            if(!array_key_exists($row["ID"],$rowName) && $row["PersonName"]!=""){
                $rowName[$row["ID"]] = $row["PersonName"];
               // echo "First=".$row["PersonName"]."<br>";
            }else{
                //echo "Next=".$row["PersonName"]."<br>";
            }
               $k = $row["ID"]."_".getMinutes($row["AuthDateTime"])."_".$row["DeviceName"];
          //  echo "\nKey::".$k.";;";
            $all_rows[$k] = $row;
        }
    }
    foreach($all_rows as $k=>$row){
    
        $all_rows[$k]["order"] = $rowName[$row["ID"]]."_".getMinutes($row["AuthDateTime"])."_".$row["DeviceName"];
    } 
//echo "Before";    
  //  pr($all_rows);
    usort($all_rows,"sortByOrder");
//echo "After";
  //  pr($all_rows);
    foreach($all_rows as $row){
       
     $now = time();
     $time =  extractTime($row["AuthDateTime"]);
     $date_ =  extractDate($row["AuthDateTime"]);
    $id = $row["ID"]."_".$date_;
    if($row["ID"]==24){
    //echo $id;
    //pr(array_keys($resu));
    }
     if(in_array($id,array_keys($resu))){
        
        $timing = $resu[$id]["timings"];
        
      //  pr($cnt);
        $count = $cnt[$id];
      
        $prev_timing = $timing[$count];
        if(in_array("IN",array_keys($prev_timing)) && contains("OUT",$row["DeviceName"])){
            $prev_timing["OUT"] = getMinutes($time);
            $timing[$count] = $prev_timing;
        }else if(in_array("IN",array_keys($prev_timing)) && contains("IN",$row["DeviceName"])){
            $timing[++$cnt[$id]] = array("IN" =>getMinutes($time));
        }else if(in_array("OUT",array_keys($prev_timing)) && contains("OUT",$row["DeviceName"])){
            $timing[++$cnt[$id]] = array("OUT" =>getMinutes($time));
        }else if(in_array("OUT",array_keys($prev_timing)) && contains("IN",$row["DeviceName"])){
            $timing[++$cnt[$id]] = array("IN" =>getMinutes($time));
        }else{
             if($row["ID"]==24){
                //echo $id;
               // echo "\n".$row["DeviceName"]."***".$cnt;
                //pr($prev_timing);
                }
        }
        $resu[$id]["timings"] = $timing;
     }else{
        $cnt[$id]=0;
        //echo "\nInitalCount".$id;
        //pr($cnt);
        if(contains("IN",$row["DeviceName"])){
            $flag_ = "IN";    
        }else{
            $flag_ = "OUT";
        }
        $resu[$id] =  array("name"=>$rowName[$row["ID"]],"id"=>$row["ID"],"date"=>extractDate($row["AuthDateTime"]),"timings"=>array($cnt[$id] =>array($flag_ =>getMinutes($time))));
        
     }
    }
    //pr($resu);
    return $resu;
}
function getReportContent($input){
    $resu = getAssociateArr($input);
    //pr($resu);
    
    foreach($resu as $k => $val) {
        $startTime ="";
        $endTime ="";
    	if(is_array($val["timings"])){
    		$arrCnt = count($val["timings"]);
    		if($arrCnt>1){
    		    $cls = 'red';
    		    $tot_time ="0:00";
    		    foreach($val["timings"] as $each){
              	    $in = (array_key_exists("IN", $each))?getMinutes($each["IN"]):"";
              	    $out = (array_key_exists("OUT", $each))?getMinutes($each["OUT"]):"";
              	    $inside_diff = ($in!="" && $out !="")?getDiffTime($each["OUT"],$each["IN"]):"";
              	    if($inside_diff!=""){
              	        $tot_time = getAddedTime($tot_time,$inside_diff);
              	    }
              	}
    		}else{
    		    $cls ='';
    		}
    		if($arrCnt>0){
    			if(array_key_exists("IN", $val["timings"][0])){
    				$startTime = $val["timings"][0]["IN"];
    			}
    			
    			if(array_key_exists("OUT", $val["timings"][$arrCnt-1])){
    				$endTime = $val["timings"][$arrCnt-1]["OUT"];
    			}
    		}
    		if($cls ==''){
    		    if($endTime!="" && $startTime!=""){
    		        $tot_time = getDiffTime($endTime,$startTime);
    		    }else{
    		        $tot_time = "0:00";
    		    }
    		}
    	}
      	$html.="<tr class='new'><td>". $k."</td><td>".$val["name"]."</td><td>".$val["date"]."</td><td>".getMinutes($startTime)."</td><td>".getMinutes($endTime)."</td><td></td><td><span class='$cls'>".$tot_time."</span></td></tr>";
      	if(is_array($val["timings"])){
      	    $arrCnt = count($val["timings"]);
          	if($arrCnt>1){
          	   foreach($val["timings"] as $each){
          	    $in = (array_key_exists("IN", $each))?getMinutes($each["IN"]):"";
          	    $out = (array_key_exists("OUT", $each))?getMinutes($each["OUT"]):"";
          	    $inside_diff = ($in!="" && $out !="")?getDiffTime($each["OUT"],$each["IN"]):"";
          	    $html.="<tr><td></td><td></td><td></td><td>".$in."</td><td>".$out."</td><td>$inside_diff</td><td></td></tr>";
          	   }
          	    
          	}
      	}
    }
    return $html;
}
function getClearReportContent($input){
    $resu = getAssociateArr($input);
 //   pr($resu);
    foreach($resu as $k => $val) {
        $startTime ="";
        $endTime ="";
        $startFlag = false;
    	if(is_array($val["timings"])){
    		$arrCnt = count($val["timings"]);
    		if($arrCnt>1){
    		    $cls = 'red';
    		    $tot_time ="0:00";
    		 //   pr($val["timings"]);
    		    foreach($val["timings"] as $each){
    		        if($startTime=="" && $each["IN"]!=""){
    		            $startTime = $each["IN"];
    		            $startFlag = true;
    		        }
    		        if($each["OUT"]!="" && $startFlag){
    		            $endTime = $each["OUT"];
    		        }
              	    $in = (array_key_exists("IN", $each))?getMinutes($each["IN"]):"";
              	    $out = (array_key_exists("OUT", $each))?getMinutes($each["OUT"]):"";
              	    $inside_diff = ($in!="" && $out !="")?getDiffTime($each["OUT"],$each["IN"]):"";
              	    if($inside_diff!=""){
              	        $tot_time = getAddedTime($tot_time,$inside_diff);
              	    }
              	}
    		}else{
    		    $cls ='';
    		}
    		if($arrCnt>0){
    			if(array_key_exists("IN", $val["timings"][0])){
    				$startTime = $val["timings"][0]["IN"];
    			}
    			
    			if(array_key_exists("OUT", $val["timings"][$arrCnt-1])){
    				$endTime = $val["timings"][$arrCnt-1]["OUT"];
    			}
    		}
    		if($cls ==''){
    		    if($endTime!="" && $startTime!=""){
    		        $tot_time = getDiffTime($endTime,$startTime);
    		    }else{
    		        $tot_time = "0:00";
    		    }
    		}
    	}
    	if($tot_time=="0:00"){
    	   $tot_time=""; 
    	}
      	$html.="<tr class='new'><td><span class='uni_id_cls'>". $val["id"]."</span></td><td><span class='person_name_cls'>".$val["name"]."</span></td><td><span class='date_cls'>".$val["date"]."</span></td><td>".getMinutes($startTime)."</td><td>".getMinutes($endTime)."</td><td></td><td><span class='$cls'>".$tot_time."</span></td></tr>";
      	if(is_array($val["timings"])){
      	    $arrCnt = count($val["timings"]);
          	if($arrCnt>1){
          	   foreach($val["timings"] as $each){
          	    $in = (array_key_exists("IN", $each))?getMinutes($each["IN"]):"";
          	    $out = (array_key_exists("OUT", $each))?getMinutes($each["OUT"]):"";
          	    $inside_diff = ($in!="" && $out !="")?getDiffTime($each["OUT"],$each["IN"]):"";
          	    $cls_bg = ($in=="" || $out =="")?"inout_missing":"";
          	    $html.="<tr class='$cls_bg'><td></td><td></td><td></td><td>".$in."</td><td>".$out."</td><td>$inside_diff</td><td></td></tr>";
          	   }
          	    
          	}
      	}
    }
    return $html;
}
?>