<!doctype html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv='cache-control' content='no-cache'> 
    <meta http-equiv='expires' content='0'> 
    <meta http-equiv='pragma' content='no-cache'> 
	<title>P1 Electrical</title>
	<link media="all" type="text/css" href="css/global.css" rel="stylesheet">
	<link rel="stylesheet" href="css/jquery-ui.css">

	<script src="js/jquery-3.5.1.min.js"></script>
	<script src="js/jquery-ui.js"></script>
	<style>
	    .red{
	        color:red;
	    }
	    .tr-inputs table {
            padding-top: 13px;
        }
        tr.tr-inputs table td span {
            padding-left: 14px;
        }
        tr.new td {
            border-top: thin solid black;
        }
        span.person_name_cls:hover ,span.date_cls:hover,span.uni_id_cls:hover,#last_updated_time_id:hover{
            cursor: pointer;
        }
        span.uni_id_cls,span.person_name_cls,span.date_cls{
        color:blue;
        }
        .inout_missing td {
            background-color: lightyellow !important;
        }
        
	</style>
	<script>
	  var timezone =new Date().getTimezoneOffset();
      $(function() {
        $("#datepicker").datepicker({ dateFormat: 'yy-mm-dd' });
        $("#all_rows_id").on('click',".uni_id_cls",function(){
            $("#id_filter").val($(this).html().trim()).blur();  
        });
        $("#all_rows_id").on('click','.person_name_cls',function(){
            $("#name_filter").val($(this).html().trim()).blur();
        });
        $("#all_rows_id").on('click','.date_cls',function(){
            $("#datepicker").val($(this).html().trim()).change();
        });
      });
      $(document).ready(function(){
        function throttle(f, delay){
            var timer = null;
            return function(){
                var context = this, args = arguments;
                clearTimeout(timer);
                timer = window.setTimeout(function(){
                    f.apply(context, args);
                },
                delay || 2000);
            };
        }
        
        
        function getData(field,value){
            
            if(value!=undefined && value!=null && value!=""){
                $('body').css('cursor', 'progress'); 
                $.ajax({
                    url: "debug_report_filter.php?timezone="+timezone+"&"+field+"="+value,
                    type: "GET",
                    success: function(re){
                       // console.log(re);
                        $("#all_rows_id").html(re["html"]);
                        $("#last_updated_time_id").html(re["lastUpdate"]);
                        $('body').css('cursor', 'default'); 
                    },
                    error:function(e){
                        $('body').css('cursor', 'default');
                    },
                    dataType: "json"
                });
            }else{
                $("#all_rows_id").html("<tr><td colspan='8'>No Results Found<\/td><\/tr>");
            }
        }
        
        
        var currentDate =new Date().toJSON().slice(0,10).replace(/-/g,'-');
        $("#datepicker").val(currentDate);
        getData("date",currentDate);
        
        $("#last_updated_time_id").click(function(){
            var dt = $(this).attr('data');
            $("#datepicker").val(dt.trim()).change();
            
        });
        $("#datepicker").change(function(){
            console.log("dateChange");
            $("#name_filter").val("");
            $("#id_filter").val("");
            getData("date",$("#datepicker").val());
        });
        $("#name_filter").keyup(throttle(function(){
            console.log("nameChange");
            
            
        }));
        $("#name_filter").bind('blur keyup',function(e) {  
          if (e.type === 'blur' || e.keyCode === 13){
            $("#id_filter").val("");
            $("#datepicker").val("");
            getData("PersonName",$("#name_filter").val());  
          }    
        });  
        $("#id_filter").bind('blur keyup',function(e) { 
          if (e.type === 'blur' || e.keyCode === 13){
            $("#name_filter").val("");
            $("#datepicker").val("");
            getData("ID",$("#id_filter").val());
          }
        });
      
      });
  </script>
  

</head>
<?php
date_default_timezone_set("UTC");
include 'config/config.php';
$sql_ = "SELECT AuthDateTime FROM scanner ORDER BY AuthDateTime DESC LIMIT 0,1";
$result_ = mysqli_query($GLOBALS['con'],$sql_);
if($max_timestamp =  mysqli_fetch_array($result_, MYSQLI_ASSOC)){
  $lastUpdatedOne =  $max_timestamp["AuthDateTime"];
}
$timeZoneClient = "<script>document.writeln(new Date().getTimezoneOffset());</script>";
?>
<body>
	<table width="100%" border="0" cellspacing="0" cellpadding="0" class="whole-page">
		<tbody>
			<tr class="tr-head">
				<td>
					<table width="100%" border="0" cellspacing="0" cellpadding="0" class="header-blue">
						<tbody>
						<tr>
							<td width="33%">
								<span><img src="imgs/p1_logo.png" alt="P1 Electrical Services" /></span>
							</td>
							<td align="center" width="33%">
								<div class="mid-title"><span class="middle"><h2>P1 Attendance</h2></span></div>
								<div class="mid-time">Last Update : <span class="middle" id="last_updated_time_id" data="<?php echo date('Y-m-d', strtotime($lastUpdatedOne)); ?>"><?php echo date('H:i d/m/y', strtotime($lastUpdatedOne)); ?></span></div>
							</td>
							<td align="right" width="33%">
									<span class="last-header"><h2></h2></span>
							</td>							
						</tr>
						</tbody>
					</table>
				</td>
			</tr>
			<tr class="tr-bar">
				<td class="nav-bg">	
					<table width="990px" border="0" align="center" cellpadding="0" cellspacing="0">
						<tbody><tr><td></td></tr></tbody>
					</table>	
				</td>
			</tr>
			<tr class="tr-inputs">
				<td>	
					<table width="990px" border="0" align="left" cellpadding="0" cellspacing="0">
						<tbody><tr><td></td></tr></tbody>
					</table>	
				</td>
			</tr>
			<tr class="tr-content">
				<td>
					<div id="view_page">
					
					 <table class="apply-table-view">
						<thead>
    						<tr>
    							<td>Id<input type="text" id="id_filter" /></td>
    						    <td>Name<input type="text" id="name_filter" /></td>
    							<td>Date<input type="text" class="date" id="datepicker" readonly /></td>
    							<td>IN</td>
    							<td>OUT</td>
    							<td>Part Duration</td>
    							<td>Total Duration</td>
    						</tr>
						</thead>
						<tbody id="all_rows_id">
    						<td colspan="7">Please choose date!!</td>
					    </tbody>
					 </table>
					
					</div>
				</td>
			</tr>
			<tr class="tr-foot">
			    <td>
			        <footer class="foot-btm">
            		     <table width="100%" border="0" cellspacing="0" cellpadding="0" class="header-blue foot">
            						<tbody>
            						<tr>
            						    <td width="70%">
            								<span>&nbsp;</span>
            							</td>
            							<td width="15%">
            								<span><img src="imgs/foot1.png" alt="P1 Electrical Services" /></span>
            							</td>
            							<td width="15%">
            								<span><img src="imgs/foot2.jpg" alt="P1 Electrical Services" /></span>
            							</td>
            						</tr>
            						</tbody>
            					</table>
            		</footer>
			    
					</td>
			</tr>
		</tbody>
		</table>
		
		</body>
</html>