<!doctype html>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
	<meta http-equiv='cache-control' content='no-cache'> 
    <meta http-equiv='expires' content='0'> 
    <meta http-equiv='pragma' content='no-cache'> 
	<title>P1 Electrical</title>
	<link media="all" type="text/css" href="css/global_atten.css" rel="stylesheet">
	<link rel="stylesheet" href="css/jquery-ui.css">

	<script src="js/jquery-3.5.1.min.js"></script>
	<script src="js/jquery-ui.js"></script>
	<style>
	    .red{
	        color:red;
	    }
	    .tr-inputs table {
            padding-top: 13px;
        }
        tr.tr-inputs table td span {
            padding-left: 14px;
        }
        tr.new td {
            border-top: thin solid black;
        }
        span.person_name_cls:hover ,span.date_cls:hover,span.uni_id_cls:hover,#last_updated_time_id:hover,span.dept_cls:hover{
            cursor: pointer;
        }
        span.uni_id_cls,span.person_name_cls,span.date_cls,span.dept_cls{
        color:blue;
        }
        .inout_missing td {
            background-color: lightyellow !important;
        }
        .aleft{
            text-align:right;
        }
        #site_cnt_date{
            font-size: 16px;
            font-weight: bold;
        }
        .tb-field{
            width: 97%;
            height: 23px;
        }
        .tb-field-small{
            width: 93%;
            height: 23px;
        }
        td.head-right-bar {
            min-width: 174px;
        }
	</style>
	<script>
	  var timezone =new Date().getTimezoneOffset();
      $(function() {
        $("#datepicker").datepicker({ dateFormat: 'yy-mm-dd' });
        $("#all_rows_id").on('click',".uni_id_cls",function(){
            $("#id_filter").val($(this).text().trim()).blur();  
        });
        $("#all_rows_id").on('click','.person_name_cls',function(){
            $("#name_filter").val($(this).text().trim()).blur();
        });
        $("#all_rows_id").on('click','.date_cls',function(){
            $("#datepicker").val($(this).text().trim()).change();
        });
        $("#all_rows_id").on('click','.dept_cls',function(){
            $("#dept_filter").val($(this).text().trim()).blur();
        });
      });
      $(document).ready(function(){
        function throttle(f, delay){
            var timer = null;
            return function(){
                var context = this, args = arguments;
                clearTimeout(timer);
                timer = window.setTimeout(function(){
                    f.apply(context, args);
                },
                delay || 2000);
            };
        }
        
        
        function getData(field,value){
            
            if(value!=undefined && value!=null && value!=""){
                $('body').css('cursor', 'progress'); 
                var data_ = {};
                data_["timezone"] = timezone;
                data_[field] = value;
                $.ajax({
                    url: "report_filter.php",
                    type: "GET",
                    data:data_,
                    success: function(re){
                       // console.log(re);
                        $("#all_rows_id").html(re["html"]);
                        $("#last_updated_time_id").html(re["lastUpdate"]);
                        console.log(field);
                        if(field=="date"){
                            $("#date_selection").html(re["date_site_count"]);
                            $("#date_site_count").css('visibility', 'visible');
                            $("#site_cnt_date").html(value).css('visibility', 'visible');
                            
                        }else{
                             $("#site_cnt_date").css('visibility', 'hidden');
                            $("#date_site_count").css('visibility', 'hidden');
                        }
                        $("#onsite_count").html(re["in_count"]);
                        $('body').css('cursor', 'default'); 
                    },
                    error:function(e){
                        $('body').css('cursor', 'default');
                    },
                    dataType: "json"
                });
            }else{
                $("#all_rows_id").html("<tr><td colspan='8'>No Results Found<\/td><\/tr>");
            }
            
        }
        
        
        var currentDate =new Date().toJSON().slice(0,10).replace(/-/g,'-');
        $("#datepicker").val(currentDate);
        getData("date",currentDate);
        
        $("#last_updated_time_id").click(function(){
            var dt = $(this).attr('data');
            $("#datepicker").val(dt.trim()).change();
            
        });
        $("#datepicker").change(function(){
            console.log("dateChange");
            $("#name_filter").val("");
            $("#dept_filter").val("");
            $("#id_filter").val("");
            getData("date",$("#datepicker").val());
        });
        $("#name_filter").keyup(throttle(function(){
            console.log("nameChange");
            
            
        }));
        $("#name_filter").bind('blur keyup',function(e) {  
          if (e.type === 'blur' || e.keyCode === 13){
            $("#id_filter").val("");
            $("#datepicker").val("");
            $("#dept_filter").val("");
            getData("PersonName",$("#name_filter").val());  
          }    
        });  
        $("#dept_filter").bind('blur keyup',function(e) {  
          if (e.type === 'blur' || e.keyCode === 13){
            $("#id_filter").val("");
            $("#datepicker").val("");
            $("#name_filter").val("");
            getData("Dept",$("#dept_filter").val());  
          }    
        });  
        $("#id_filter").bind('blur keyup',function(e) { 
          if (e.type === 'blur' || e.keyCode === 13){
            $("#name_filter").val("");
            $("#datepicker").val("");
            $("#dept_filter").val("");
            getData("ID",$("#id_filter").val());
          }
        });
      
      });
  </script>
  

</head>
<?php
date_default_timezone_set("UTC");
include 'config/config.php';
$sql_ = "SELECT AuthDateTime FROM scanner ORDER BY AuthDateTime DESC LIMIT 0,1";
$result_ = mysqli_query($GLOBALS['con'],$sql_);
if($max_timestamp =  mysqli_fetch_array($result_, MYSQLI_ASSOC)){
  $lastUpdatedOne =  $max_timestamp["AuthDateTime"];
}
$timeZoneClient = "<script>document.writeln(new Date().getTimezoneOffset());</script>";
?>
<body>
	<table width="100%" border="0" cellspacing="0" cellpadding="0" class="whole-page">
		<tbody>
			<tr class="tr-head">
				<td>
					<table width="100%" border="0" cellspacing="0" cellpadding="0" class="header-blue">
						<tbody>
						<tr>
							<td width="33%">
								<span><img src="imgs/p1_logo.png" alt="P1 Electrical Services" /></span>
							</td>
							<td align="center" width="33%">
								<div class="mid-title-2">
								    <span class="middle"><h2>Attendance Report</h2></span>
								    <div class="mid-time">Last Movement : <span class="middle" id="last_updated_time_id" data="<?php echo date('Y-m-d', strtotime($lastUpdatedOne)); ?>"><?php echo date('H:i d/m/y', strtotime($lastUpdatedOne)); ?></span></div>
								</div>
								
							</td>
							<td align="right" width="33%" class="head-right-bar">
								<div><span class="last-header-2"><a href='index.html'><h2><span id="onsite_count"></span> On Site Today</h2></a></span></div>
								<div id="date_site_count">
								    <span class="last-header-2"><h2><span id="date_selection"></span> Attended Site</h2><h2><span id="site_cnt_date"></span></h2></span>
								    
								</div>
							</td>							
						</tr>
						</tbody>
					</table>
				</td>
			</tr>
		
		
			<tr class="tr-content">
				<td>
					<div id="view_page">
					
					 <table class="apply-table-view">
						<thead>
    						<tr>
    							<td style="width:150px"><input type="text" id="id_filter" placeholder="Id" class="tb-field"/></td>
    							<td style="width:70px"><input type="text" id="dept_filter" placeholder="Dept" class="tb-field-small" /></td>
    						    <td style="width:250px"><input type="text" id="name_filter" placeholder="Name" class="tb-field"/></td>
    							<td style="width:100px"><input type="text" class="date tb-field-small" id="datepicker" readonly placeholder="Date" /></td>
    							<td style="width:60px" class="aleft">IN</td>
    							<td style="width:60px" class="aleft">OUT</td>
    							<td style="width:60px" class="aleft">Part Duration</td>
    							<td style="width:60px" class="aleft">Total Duration</td>
    						</tr>
						</thead>
						<tbody id="all_rows_id">
    						<td colspan="7">Please choose date!!</td>
					    </tbody>
					 </table>
					
					</div>
				</td>
			</tr>
			<tr class="tr-foot">
			    <td>
			        <footer class="foot-btm">
            		     <table width="100%" border="0" cellspacing="0" cellpadding="0" class="header-blue foot">
            						<tbody>
            						<tr>
            						    <td width="70%">
            								<span>&nbsp;</span>
            							</td>
            							<td width="15%">
            								<span><img src="imgs/foot1.png" alt="P1 Electrical Services" /></span>
            							</td>
            							<td width="15%">
            								<span><img src="imgs/foot2.jpg" alt="P1 Electrical Services" /></span>
            							</td>
            						</tr>
            						</tbody>
            					</table>
            		</footer>
			    
					</td>
			</tr>
		</tbody>
		</table>
		
		</body>
</html>